<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<?php if(get_option(THEMEPREFIX.'_general_responsive', 'true') != 'false') : ?><meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0"><?php endif; ?>
<meta name="apple-mobile-web-app-capable" content="yes">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php $verification = get_option(THEMEPREFIX.'_seo_webmaster'); if($verification) : ?>
<meta name="google-site-verification" content="<?php echo $verification; ?>">
<?php endif; ?>
<?php if (is_page() || is_single()) { $desc = get_post_meta($post->ID, "seodescription", true); if(get_option(THEMEPREFIX.'_seo') == "false" && $desc) : ?>
<meta name="description" content="<?php echo $desc; ?>">
<?php endif; } ?>
<?php $pub = get_option(THEMEPREFIX.'_seo_publisher'); if($pub) : ?>
<link rel="publisher" href="<?php echo $pub ?>">
<?php endif; ?>
<?php $favicon = get_option(THEMEPREFIX.'_general_favicon'); if($favicon) : ?>
<link rel="icon" type="image/png" href="<?php echo $favicon; ?>">
<?php endif; ?>
<?php $iphone_favicon = get_option(THEMEPREFIX.'_general_iphone_favicon'); if($iphone_favicon) : ?>
<link rel="apple-touch-icon" href="<?php echo $iphone_favicon; ?>">
<?php endif; ?>
<?php $iphone_favicon_retina = get_option(THEMEPREFIX.'_general_iphone_favicon_retina'); if($iphone_favicon_retina) : ?>
<link rel="apple-touch-icon" sizes="114x114" href="<?php echo $iphone_favicon_retina; ?>">
<?php endif; ?>
<?php $ipad_favicon = get_option(THEMEPREFIX.'_general_ipad_favicon'); if($ipad_favicon) : ?>
<link rel="apple-touch-icon" sizes="72x72" href="<?php echo $ipad_favicon; ?>">
<?php endif; ?>
<?php $ipad_favicon_retina = get_option(THEMEPREFIX.'_general_ipad_favicon_retina'); if($ipad_favicon_retina) : ?>
<link rel="apple-touch-icon" sizes="144x144" href="<?php echo $ipad_favicon_retina; ?>">
<?php endif; ?>

<?php echo get_option(THEMEPREFIX.'_custom_head') ?>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="site">
	<header id="header">
		<div id="header-holder">
			<div class="container">
				<div class="row">
				<div class="col-lg-12 clearfix">
					<div class="row">
				<?php $header_left = get_option(THEMEPREFIX.'_header_1st_text_line'); if($header_left):  ?>
					<div class="col-lg-6 col-sm-6 col-xs-12 text-left header-info"><?php echo do_shortcode($header_left); ?></div>
				<?php endif; ?>
				<?php 
					$lang_selector = curly_language_selector_flags();
					$header_right = get_option(THEMEPREFIX.'_header_2nd_text_line');
					if ($lang_selector != null) : ?>
					<div class="col-lg-6 col-sm-6 col-xs-12 text-right header-info"><?php echo $lang_selector ?></div>
					<?php elseif ($header_right) : ?>
					<div class="col-lg-6 col-sm-6 col-xs-12 text-right header-info"><?php echo do_shortcode($header_right); ?></div>
					<?php endif; ?>
					</div>
				</div>
				<div class="col-lg-12">
					<?php echo curly_get_logo(); ?>
				</div>
				</div>
			</div>
			<nav role="navigation" id="navigation">
				<?php wp_nav_menu(array('theme_location' => 'menuMainMenu', 'container_class' => 'container')); ?>
			</nav>
			<div class="container page-heading">
					<div class="pull-right hidden-xs"><?php echo curly_breadcrumbs(); ?></div>
					<h1><?php echo curly_get_page_title(); ?></h1>
			</div>
		</div>	
	</header>
	<?php if (is_home() || is_archive()) : ?>
	<aside class="blog-sort">
		<div class="container">
			<div class="row">
				<div class="col-lg-12 text-right">
					<h6 class="pull-left"><?php echo __('Sort Articles', 'CURLYTHEME') ?></h6>
					<ul id="filters">
						<li><a href="<?php echo get_permalink(get_option('page_for_posts')) ?>/" data-filter="*" <?php if(is_home()) echo 'class="active"'; ?> ><?php _e('Show All','CURLYTHEME') ?></a></li>
						<?php
						$categories =  get_categories(array('number' => 4, 'orderby' => 'count')); 
						 foreach ($categories as $category) {
						 	$option = '<li><a href="'.get_category_link( $category->term_id ).'" ';
						 	$option .= (is_category($category->term_id)) ? 'class="active"' : null;
							$option .= '>'.$category->cat_name;
							$option .= '</a></li>';
							echo $option;
						 }
					?>
					</ul>
				</div>
			</div>
		</div>
	</aside>
	<?php endif; ?>